<?php
//session_start(); // Ensure session is started


if (isset($_SESSION["profile"]) && $_SESSION["profile"] == "Special") {
    echo '<script>window.location = "home";</script>';
    return;
}

$xml = ControllerSales::ctrDownloadXML();

if ($xml && isset($_GET["xml"])) {
    $filename = basename($_GET["xml"]); // sanitize input
    if (file_exists($filename . ".xml")) {
        rename($filename . ".xml", "xml/" . $filename . ".xml");
        echo '<a class="btn btn-block btn-success openXML" file="xml/' . $filename . '.xml" href="sales">
                The XML file has been created successfully
                <span class="fa fa-times pull-right"></span>
              </a>';
    }
}
?>

<div class="content-wrapper">
    <section class="content-header">
        <h1>Sales Management</h1>
        <ol class="breadcrumb">
            <li><a href="home"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Dashboard</li>
        </ol>
    </section>

    <section class="content">
        <div class="box">
            <div class="box-header with-border">
                <a href="create-sale">
                    <button class="btn btn-success"><i class="fa fa-plus"></i> Add Sale</button>
                </a>

                <button type="button" class="btn btn-primary pull-right" id="daterange-btn">
                    <span><i class="fa fa-calendar"></i> Date Range</span>
                    <i class="fa fa-caret-down"></i>
                </button>
            </div>

            <div class="box-body">
                <table class="table table-bordered table-hover table-striped dt-responsive tables" width="100%">
                    <thead>
                        <tr>
                            <th style="width:10px">#</th>
                            <th>Bill</th>
                            <th>Customer</th>
                            <th>Seller</th>
                            <th>Payment Method</th>
                            <th>Net Cost</th>
                            <th>Total Cost</th>
                            <th>Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php
                        $initialDate = $_GET["initialDate"] ?? null;
                        $finalDate = $_GET["finalDate"] ?? null;

                        $sales = ControllerSales::ctrSalesDatesRange($initialDate, $finalDate);

                        foreach ($sales as $key => $sale) {
                            $customer = ControllerCustomers::ctrShowCustomers("id", $sale["idCustomer"]);
                            $seller = ControllerUsers::ctrShowUsers("id", $sale["idSeller"]);

                            echo '<tr>
                                <td>' . ($key + 1) . '</td>
                                <td>' . $sale["code"] . '</td>
                                <td>' . $customer["name"] . '</td>
                                <td>' . $seller["name"] . '</td>
                                <td>' . $sale["paymentMethod"] . '</td>
                                <td>₦ ' . number_format($sale["netPrice"], 2) . '</td>
                                <td>₦ ' . number_format($sale["totalPrice"], 2) . '</td>
                                <td>' . $sale["saledate"] . '</td>
                                <td>
                                    <div class="btn-group">
                                        <a class="btn btn-success" href="index.php?route=sales&xml=' . $sale["code"] . '">XML</a>

                                        <a href="extensions/escpos/print_receipts.php?code=' . $sale["code"] . '" target="_blank" class="btn btn-warning">
                                            <i class="fa fa-print"></i>
                                        </a>';

                            if ($_SESSION["profile"] == "Administrator") {
                                echo '
                                        <button class="btn btn-primary btnEditSale" idSale="' . $sale["id"] . '">
                                            <i class="fa fa-pencil"></i>
                                        </button>
                                        <button class="btn btn-danger btnDeleteSale" idSale="' . $sale["id"] . '">
                                            <i class="fa fa-trash"></i>
                                        </button>';
                            }

                            echo '      </div>
                                </td>
                            </tr>';
                        }
                        ?>
                    </tbody>
                </table>

                <?php
                $deleteSale = new ControllerSales();
                $deleteSale->ctrDeleteSale();
                ?>
            </div>
        </div>
    </section>
</div>
