<?php

namespace App\Console\Commands;

use App\Models\NewsletterCampaign;
use App\Services\NewsletterService;
use Illuminate\Console\Command;

class SendScheduledNewsletters extends Command
{
    protected $signature = 'newsletters:send-due';

    protected $description = 'Send newsletter campaigns that are scheduled and ready to deliver.';

    public function handle(NewsletterService $newsletterService): int
    {
        $campaigns = NewsletterCampaign::due()->get();

        if ($campaigns->isEmpty()) {
            $this->info('No scheduled newsletter campaigns are ready to send.');
            return self::SUCCESS;
        }

        foreach ($campaigns as $campaign) {
            $this->info(sprintf('Sending campaign #%d (%s)...', $campaign->id, $campaign->subject));
            $sentCount = $newsletterService->sendCampaign($campaign);
            $this->info(sprintf('Campaign #%d sent to %d subscribers.', $campaign->id, $sentCount));
        }

        return self::SUCCESS;
    }
}
