<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    public function index(Request $request)
    {
        // Authorization handled by admin route middleware (role: admin,cashier)
        // Avoid Request::string() here because it returns a Stringable object that is truthy even when empty
        $status = $request->query('status');
        $testOnly = (bool) $request->query('test');

        $q = Order::query()
            ->when(is_string($status) && $status !== '', fn($x) => $x->where('status', $status))
            ->when($testOnly, fn($x) => $x->where('metadata->is_test', true))
            ->latest('created_at');

        $orders = $q->paginate(20)->withQueryString();
        $filtersApplied = (bool) ($status || $testOnly);
        return view('admin.orders.index', compact('orders','status','testOnly','filtersApplied'));
    }

    public function show(Order $order)
    {
        // Authorization handled by admin route middleware (role: admin,cashier)
        $order->load('items');
        return view('admin.orders.show', compact('order'));
    }

    public function updateStatus(Request $request, Order $order)
    {
        $this->authorize('update', $order);
        $data = $request->validate(['status' => 'required|string|in:pending,paid,fulfilled,cancelled']);
        $order->update(['status' => $data['status']]);
        \App\Services\AuditService::log('order.status', $order, $request->user(), ['status' => $data['status']]);
        return back()->with('status','Order status updated');
    }
}
