<?php

namespace App\Http\Controllers;

use App\Models\Product;
use Illuminate\Http\Request;

class BookController extends Controller
{
    public function index(Request $request)
    {
        $searchTerm = trim((string) $request->input('q'));
        $perPage = 12;

        $products = Product::query()
            ->with('category')
            ->when($searchTerm !== '', function ($query) use ($searchTerm) {
                $query->where('title', 'like', '%'.$searchTerm.'%');
            })
            ->latest('published_at')
            ->paginate($perPage)
            ->withQueryString();

        return view('books.index', [
            'products' => $products,
            'searchTerm' => $searchTerm,
        ]);
    }

    public function show(string $slug)
    {
        $product = Product::where('slug', $slug)->firstOrFail();
        $related = Product::query()->where('id', '!=', $product->id)->latest('published_at')->take(4)->get();

        return view('books.show', compact('product', 'related'));
    }
}

