<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class ContactController extends Controller
{
    public function show()
    {
        return view('contact');
    }

    public function send(Request $request)
    {
        $data = $request->validate([
            'name' => ['required','string','max:100'],
            'email' => ['required','email'],
            'message' => ['required','string','max:5000'],
        ]);
        // Queue email later via mailable
        return back()->with('status','Message received. We will reply soon.');
    }
}

