<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use Symfony\Component\HttpFoundation\Response;

class CheckoutGate
{
    public function handle(Request $request, Closure $next): Response
    {
        // Not logged in: send to login with a friendly notice
        if (! $request->user()) {
            session()->flash('auth.notice', 'Please login or create an account to checkout.');
            session()->flash('toast', 'Login required to continue to checkout.');
            return redirect()->guest(route('login'));
        }

        // Logged in but not verified
        if (is_null($request->user()->email_verified_at)) {
            session()->flash('auth.notice', 'Please verify your email to continue to checkout.');
            session()->flash('toast', 'Please verify your email to continue.');
            return redirect()->route('verification.notice');
        }

        return $next($request);
    }
}

