<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AddToCartRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    protected function prepareForValidation(): void
    {
        $variant = strtolower($this->input('variant', 'digital'));
        $variant = $variant === 'hardcopy' ? 'hardcopy' : 'digital';

        $this->merge([
            'variant' => $variant,
            'qty' => $variant === 'hardcopy' ? $this->input('qty') : 1,
        ]);
    }

    public function rules(): array
    {
        return [
            'variant' => ['required','string','in:digital,hardcopy'],
            'qty' => ['required_if:variant,hardcopy','integer','min:1','max:99'],
        ];
    }
}
