<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CheckoutIntentRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => ['required','string','max:100'],
            'email' => ['required','email'],
            'address' => ['required','array'],
            'address.line1' => ['required','string','max:255'],
            'address.city' => ['required','string','max:100'],
            'address.state' => ['nullable','string','max:100'],
            'address.country' => ['required','string','max:100'],
            'address.postal_code' => ['nullable','string','max:20'],
        ];
    }

    protected function prepareForValidation(): void
    {
        $address = $this->input('address', []);

        if (isset($address['country']) && is_string($address['country'])) {
            $address['country'] = strtoupper($address['country']);
        }

        if (isset($address['state']) && is_string($address['state'])) {
            $address['state'] = strtoupper($address['state']);
        }

        $this->merge(['address' => $address]);
    }
}
