<?php

namespace App\Mail;

use App\Models\Subscriber;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class NewsletterConfirmationMail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(public Subscriber $subscriber)
    {
    }

    public function build(): self
    {
        return $this
            ->subject('Confirm your newsletter subscription')
            ->view('emails.newsletter.confirm')
            ->with([
                'subscriber' => $this->subscriber,
                'confirmationUrl' => route('newsletter.confirm', $this->subscriber->token),
                'unsubscribeUrl' => route('newsletter.unsubscribe', $this->subscriber->token),
            ]);
    }
}
