<?php

namespace App\Mail;

use App\Models\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;

class OrderShippingNotificationMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @param \Illuminate\Support\Collection<int, \App\Models\OrderItem> $items
     */
    public function __construct(public Order $order, public Collection $items)
    {
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: __('Your :app order is on its way', ['app' => config('app.name', 'Store')]),
        );
    }

    public function content(): Content
    {
        return new Content(
            markdown: 'emails.orders.shipping',
            with: [
                'order' => $this->order,
                'items' => $this->items,
            ],
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
