<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PromoEntry extends Model
{
    use HasFactory;

    protected $fillable = ['promotion_id','name','email','order_number','consent','ip_address','user_agent','status'];

    protected $casts = [
        'consent' => 'boolean',
    ];

    public function promotion()
    {
        return $this->belongsTo(Promotion::class);
    }
}
