<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class Setting extends Model
{
    protected $fillable = ['key','value'];

    public static function cacheKey(string $key): string
    {
        return 'setting:'.$key;
    }

    public static function get(string $key, $default = null): mixed
    {
        return Cache::remember(static::cacheKey($key), 300, function () use ($key, $default) {
            $row = static::query()->where('key', $key)->first();
            return $row?->value ?? $default;
        });
    }

    public static function set(string $key, $value): void
    {
        static::updateOrCreate(['key' => $key], ['value' => $value]);
        Cache::forget(static::cacheKey($key));
    }

    public static function flushAllCache(): void
    {
        // As a simple approach, flush the entire cache store to ensure settings are refreshed.
        // If you use a shared cache, consider using tagged cache and invalidate the tag instead.
        try { Cache::flush(); } catch (\Throwable $e) {}
    }
}
