<?php

namespace App\Services;

use App\Models\Audit;
use App\Models\User;

class AuditService
{
    public static function log(string $action, $model, ?User $user = null, array $meta = []): void
    {
        try {
            if (!class_exists(Audit::class)) return;
            $payload = [
                'action' => $action,
                'model' => is_object($model) ? get_class($model) : (string) $model,
                'model_id' => is_object($model) && isset($model->id) ? $model->id : null,
                'user_id' => $user?->id,
                'meta' => $meta,
            ];
            // Create using fillable fields if defined
            (new Audit())->fill($payload)->save();
        } catch (\Throwable $e) {
            // swallow to avoid blocking core flows
        }
    }
}

