<?php

namespace App\Services;

use App\Mail\NewsletterCampaignMail;
use App\Models\NewsletterCampaign;
use App\Models\Subscriber;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class NewsletterService
{
    public function sendCampaign(NewsletterCampaign $campaign): int
    {
        if ($campaign->status === 'sent') {
            return $campaign->sent_count ?? 0;
        }

        $campaign->status = 'sending';
        $campaign->save();

        $sentCount = 0;

        Subscriber::confirmed()
            ->active()
            ->chunkById(200, function ($subscribers) use ($campaign, &$sentCount) {
                foreach ($subscribers as $subscriber) {
                    try {
                        Mail::to($subscriber->email)->send(new NewsletterCampaignMail($campaign, $subscriber));
                        $sentCount++;
                    } catch (\Throwable $exception) {
                        Log::error('Failed to send newsletter', [
                            'campaign_id' => $campaign->id,
                            'subscriber_id' => $subscriber->id,
                            'message' => $exception->getMessage(),
                        ]);
                    }
                }
            });

        $campaign->markSent($sentCount);

        return $sentCount;
    }
}

