<?php

namespace Database\Factories;

use App\Models\Category;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class CategoryFactory extends Factory
{
    protected $model = Category::class;

    public function definition(): array
    {
        $name = $this->faker->unique()->randomElement(['Fiction','Non-fiction','Sci-fi','Self-help','Business','Romance','Fantasy']);
        return [
            'name' => $name,
            'slug' => Str::slug($name) . '-' . Str::random(3),
        ];
    }
}

