<?php

namespace Database\Factories;

use App\Models\Order;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/** @extends Factory<Order> */
class OrderFactory extends Factory
{
    protected $model = Order::class;

    public function definition(): array
    {
        return [
            'user_id' => null,
            'email' => $this->faker->safeEmail(),
            'name' => $this->faker->name(),
            'status' => 'pending',
            'amount_kobo' => $this->faker->numberBetween(500, 100000),
            'currency' => 'USD',
            'address_json' => [
                'line1' => $this->faker->streetAddress(),
                'city' => $this->faker->city(),
                'state' => $this->faker->stateAbbr(),
                'zip' => $this->faker->postcode(),
                'country' => 'US',
            ],
            'reference' => 'ord_'.Str::uuid(),
            'metadata' => [],
        ];
    }
}