<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->string('download_path')->nullable()->after('cover_path');
            $table->string('download_disk')->nullable()->after('download_path');
            $table->unsignedBigInteger('shipping_fee_kobo')->default(0)->after('sale_price_kobo');
        });

        Schema::table('orders', function (Blueprint $table) {
            $table->unsignedBigInteger('shipping_kobo')->default(0)->after('amount_kobo');
        });

        Schema::table('order_items', function (Blueprint $table) {
            $table->string('product_type')->nullable()->after('product_id');
            $table->boolean('is_digital')->default(false)->after('product_type');
            $table->unsignedBigInteger('shipping_fee_kobo')->default(0)->after('unit_price_kobo');
        });

        Schema::table('downloads', function (Blueprint $table) {
            $table->string('disk')->default('local')->after('path');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('order_items', function (Blueprint $table) {
            $table->dropColumn(['product_type', 'is_digital', 'shipping_fee_kobo']);
        });

        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn('shipping_kobo');
        });

        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn(['download_path', 'download_disk', 'shipping_fee_kobo']);
        });

        Schema::table('downloads', function (Blueprint $table) {
            $table->dropColumn('disk');
        });
    }
};
