<?php

namespace Database\Seeders;

use App\Models\Post;
use App\Models\Comment;
use App\Models\Product;
use App\Models\Category;
use App\Models\User;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Users (roles: admin, cashier, customer)
        User::updateOrCreate(
            ['email' => 'admin@example.com'],
            ['name' => 'Admin User', 'role' => 'admin', 'email_verified_at' => now(), 'password' => bcrypt('password')]
        );
        User::updateOrCreate(
            ['email' => 'cashier@example.com'],
            ['name' => 'Cashier User', 'role' => 'cashier', 'email_verified_at' => now(), 'password' => bcrypt('password')]
        );
        User::updateOrCreate(
            ['email' => 'test@example.com'],
            ['name' => 'Test Customer', 'role' => 'customer', 'email_verified_at' => now(), 'password' => bcrypt('password')]
        );

        // Categories + Products
        $categories = Category::factory()->count(6)->create();
        Product::factory()->count(24)->create()->each(function (Product $p) use ($categories) {
            $p->update(['category_id' => $categories->random()->id]);
        });

        // Posts + comments
        Post::factory()->count(12)->create()->each(function (Post $post) {
            $count = random_int(0, 3);
            if ($count > 0) {
                $post->comments()->saveMany(Comment::factory()->count($count)->make());
            }
        });
    }
}
