@extends('layouts.site')

@section('title', 'About')
@php $aboutContent = $siteSettings->content('about'); @endphp
@section('meta_description', $aboutContent['intro_body'] ?? 'Learn about the mission, values, and creative process behind BrightQuill.')

@php
    $themes = $siteSettings->get('content.about.themes', []);
@endphp

@section('content')
<section class="section reveal">
    <div class="container grid grid-2">
        <div>
            <h1 class="mt-0">{{ $aboutContent['page_title'] ?? 'About the author' }}</h1>
            <p>{{ $aboutContent['intro_body'] ?? 'BrightQuill exists for readers who crave gentle courage and clear-eyed hope.' }}</p>
            <p class="mt-3">{{ $aboutContent['intro_secondary'] ?? 'Beyond the page, we mentor emerging authors, partner with bookstores, and share resources that make creative work sustainable.' }}</p>
            <a class="btn btn-primary mt-2" href="{{ route('contact.show') }}">{{ $aboutContent['invite_cta_label'] ?? 'Invite us to speak' }}</a>
        </div>
        <div class="card center reveal">
            <div class="card-body">
                <div class="badge-pill">{{ $aboutContent['themes_title'] ?? 'Core themes' }}</div>
                @if(is_array($themes) && count($themes))
                    <ul class="mt-2" style="list-style:disc;padding-left:1.25rem;line-height:1.6;">
                        @foreach($themes as $theme)
                            <li>{{ $theme }}</li>
                        @endforeach
                    </ul>
                @endif
            </div>
        </div>
    </div>
</section>

<section class="section stripe reveal">
    <div class="container">
        <h2 class="mt-0">{{ $aboutContent['metrics_title'] ?? 'By the numbers' }}</h2>
        <div class="grid grid-3 mt-2" style="text-align:center;">
            <div class="card reveal"><div class="card-body"><div class="h1" style="font-size:2.5rem;margin:0;">{{ $aboutContent['metric_years_value'] ?? '10+' }}</div><p class="small mt-1">{{ $aboutContent['metric_years_label'] ?? 'years curating stories' }}</p></div></div>
            <div class="card reveal"><div class="card-body"><div class="h1" style="font-size:2.5rem;margin:0;">{{ $aboutContent['metric_posts_value'] ?? '12' }}</div><p class="small mt-1">{{ $aboutContent['metric_posts_label'] ?? 'published articles' }}</p></div></div>
            <div class="card reveal"><div class="card-body"><div class="h1" style="font-size:2.5rem;margin:0;">{{ $aboutContent['metric_catalog_value'] ?? '24' }}</div><p class="small mt-1">{{ $aboutContent['metric_catalog_label'] ?? 'books &amp; goods in our catalog' }}</p></div></div>
        </div>
    </div>
</section>

<section class="section reveal">
    <div class="container grid grid-2">
        <div>
            <h2 class="mt-0">{{ $aboutContent['approach_title'] ?? 'Creative approach' }}</h2>
            <p>{{ $aboutContent['approach_body'] ?? 'Each release begins with reader interviews and a meal of margin notes.' }}</p>
        </div>
        <div>
            <h2 class="mt-0">{{ $aboutContent['collaborate_title'] ?? 'How we collaborate' }}</h2>
            <p>{{ $aboutContent['collaborate_body'] ?? "Workshops, library takeovers, podcast chats, and curated reading guides are our favorite ways to connect." }}</p>
            <a class="btn btn-outline mt-2" href="{{ route('services') }}">{{ $aboutContent['collaborate_cta_label'] ?? 'View services & tools' }}</a>
        </div>
    </div>
</section>
@endsection
