@extends('layouts.admin')

@section('content')
<div class="max-w-6xl mx-auto px-4 py-8" data-aos="fade-up">
    <div class="flex items-center justify-between mb-4">
        <h1 class="heading text-2xl">Categories</h1>
        @can('create', App\Models\Category::class)
        <a href="{{ route('admin.categories.create') }}" class="btn">New Category</a>
        @endcan
    </div>

    @if(session('status'))
        <div class="mb-3 bg-emerald-50 border border-emerald-200 text-emerald-900 text-sm rounded px-3 py-2">{{ session('status') }}</div>
    @endif
    @if(session('error'))
        <div class="mb-3 bg-red-50 border border-red-200 text-red-900 text-sm rounded px-3 py-2">{{ session('error') }}</div>
    @endif

    <div class="overflow-x-auto bg-white border border-slate-200 rounded">
        <table class="w-full text-sm table-sticky table-hover">
            <thead class="bg-slate-50 border-b border-slate-200"><tr><th class="p-2 text-left">Name</th><th class="p-2">Slug</th><th class="p-2">Products</th><th class="p-2"></th></tr></thead>
            <tbody>
                @foreach($categories as $c)
                <tr class="border-b border-slate-100">
                    <td class="p-2">{{ $c->name }}</td>
                    <td class="p-2 text-center">{{ $c->slug }}</td>
                    <td class="p-2 text-center">{{ $c->products_count }}</td>
                    <td class="p-2 text-right">
                        @can('update',$c)
                        <a href="{{ route('admin.categories.edit',$c) }}" class="text-primary">Edit</a>
                        @endcan
                        @can('delete',$c)
                        <form action="{{ route('admin.categories.destroy',$c) }}" method="post" class="inline" onsubmit="return confirm('Delete category?')">
                            @csrf @method('DELETE')
                            <button class="text-red-600 ml-2">Delete</button>
                        </form>
                        @endcan
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <div class="mt-4">{{ $categories->links() }}</div>
</div>
@endsection

