@extends('layouts.admin')

@section('content')
<div class="max-w-7xl mx-auto px-4 py-8" data-aos="fade-up">
    <div class="flex items-center justify-between flex-wrap gap-3 mb-6">
        <div>
            <h1 class="heading text-3xl">Newsletters</h1>
            <p class="text-sm text-slate-500">Manage campaigns, schedule sends, and reach {{ $subscriberStats['active'] }} active subscribers.</p>
        </div>
        <a href="{{ route('admin.newsletters.create') }}" class="btn">+ New Campaign</a>
    </div>

    @if(session('status'))
        <div class="mb-4 bg-emerald-50 border border-emerald-200 text-emerald-800 px-4 py-3 rounded">
            {{ session('status') }}
        </div>
    @endif
    @if(session('toast'))
        <div class="mb-4 bg-amber-50 border border-amber-200 text-amber-800 px-4 py-3 rounded">
            {{ session('toast') }}
        </div>
    @endif

    <div class="grid md:grid-cols-3 gap-4 mb-6 text-sm">
        <div class="bg-white border border-slate-200 rounded p-4 shadow-sm">
            <div class="text-slate-500 text-xs uppercase tracking-wide">Total subscribers</div>
            <div class="text-2xl font-semibold text-primary">{{ $subscriberStats['total'] }}</div>
        </div>
        <div class="bg-white border border-slate-200 rounded p-4 shadow-sm">
            <div class="text-slate-500 text-xs uppercase tracking-wide">Active &amp; confirmed</div>
            <div class="text-2xl font-semibold text-primary">{{ $subscriberStats['active'] }}</div>
        </div>
        <div class="bg-white border border-slate-200 rounded p-4 shadow-sm">
            <div class="text-slate-500 text-xs uppercase tracking-wide">Scheduled campaigns</div>
            <div class="text-2xl font-semibold text-primary">{{ $campaigns->where('status', 'scheduled')->count() }}</div>
        </div>
    </div>

    <div class="bg-white border border-slate-200 rounded shadow-sm overflow-x-auto">
        <table class="w-full text-sm table-sticky table-hover">
            <thead class="bg-slate-50 border-b border-slate-200">
                <tr>
                    <th class="p-2 text-left">Subject</th>
                    <th class="p-2 text-left">Status</th>
                    <th class="p-2 text-left">Scheduled</th>
                    <th class="p-2 text-left">Sent</th>
                    <th class="p-2 text-left">Recipients</th>
                    <th class="p-2 text-right">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($campaigns as $campaign)
                <tr class="border-b border-slate-100 align-top">
                    <td class="p-3">
                        <div class="font-semibold text-ink">{{ $campaign->subject }}</div>
                        <div class="text-xs text-slate-500">Created {{ optional($campaign->created_at)->format('M j, Y g:i A') }}</div>
                    </td>
                    <td class="p-3">
                        <span class="inline-flex items-center gap-2 text-xs font-semibold px-2 py-1 rounded @class([
                            'bg-sky-100 text-sky-800' => $campaign->status === 'scheduled',
                            'bg-emerald-100 text-emerald-800' => $campaign->status === 'sent',
                            'bg-amber-100 text-amber-800' => $campaign->status === 'sending',
                            'bg-slate-200 text-slate-700' => $campaign->status === 'draft',
                            'bg-rose-100 text-rose-800' => $campaign->status === 'cancelled',
                        ])">
                            {{ ucfirst($campaign->status) }}
                        </span>
                    </td>
                    <td class="p-3 text-slate-600">{{ optional($campaign->scheduled_at)->format('M j, Y g:i A') ?: '' }}</td>
                    <td class="p-3 text-slate-600">{{ optional($campaign->sent_at)->format('M j, Y g:i A') ?: '' }}</td>
                    <td class="p-3 text-slate-600">{{ $campaign->sent_count }}</td>
                    <td class="p-3 text-right space-y-2">
                        @if(in_array($campaign->status, ['scheduled', 'draft']))
                            <form action="{{ route('admin.newsletters.update', $campaign) }}" method="post" class="inline">
                                @csrf
                                @method('patch')
                                <input type="hidden" name="action" value="send_now">
                                <button class="btn px-4 py-1">Send now</button>
                            </form>
                        @endif
                        @if($campaign->status === 'scheduled')
                            <form action="{{ route('admin.newsletters.update', $campaign) }}" method="post" class="inline">
                                @csrf
                                @method('patch')
                                <input type="hidden" name="action" value="cancel">
                                <button class="btn-secondary px-4 py-1">Cancel</button>
                            </form>
                            <form action="{{ route('admin.newsletters.update', $campaign) }}" method="post" class="mt-2 text-left">
                                @csrf
                                @method('patch')
                                <input type="hidden" name="action" value="reschedule">
                                <label class="block text-xs text-slate-500 mb-1">Reschedule</label>
                                <div class="flex gap-2">
                                    <input type="datetime-local" name="scheduled_for" class="border border-slate-300 rounded px-2 py-1 text-xs w-full" value="{{ optional($campaign->scheduled_at)->format('Y-m-d\TH:i') }}">
                                    <button class="btn-secondary px-4 py-1">Save</button>
                                </div>
                            </form>
                        @endif
                        @if(in_array($campaign->status, ['draft','cancelled']))
                            <form action="{{ route('admin.newsletters.destroy', $campaign) }}" method="post" onsubmit="return confirm('Delete this campaign?');">
                                @csrf
                                @method('delete')
                                <button class="btn-secondary px-4 py-1">Delete</button>
                            </form>
                        @endif
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="p-4 text-center text-slate-500">No newsletter campaigns yet.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="mt-4">{{ $campaigns->links() }}</div>
</div>
@endsection

