﻿@extends('layouts.admin')

@section('content')
<div class="max-w-7xl mx-auto px-4 py-8" data-aos="fade-up">
    <h1 class="heading text-2xl mb-4">Orders</h1>
    <form method="get" class="mb-2 flex flex-wrap gap-3 text-sm items-center">
        <label>
            <span class="mr-1">Status</span>
            <select name="status" class="border border-slate-300 rounded px-2 py-1">
                <option value="">All</option>
                @foreach(['pending','paid','fulfilled','cancelled'] as $option)
                    <option value="{{ $option }}" @selected(($status ?? '') === $option)>{{ ucfirst($option) }}</option>
                @endforeach
            </select>
        </label>
        <label class="inline-flex items-center gap-1">
            <input type="checkbox" name="test" value="1" @checked($testOnly ?? false)>
            <span>Test only</span>
        </label>
        <button class="border border-slate-300 rounded px-3 py-1">Filter</button>
        @if($filtersApplied ?? false)
            <a href="{{ route('admin.orders.index') }}" class="border border-slate-300 rounded px-3 py-1">Reset</a>
        @endif
    </form>
    @if($filtersApplied ?? false)
    <div class="text-xs text-slate-500 mb-3">Showing filtered results. Reset to see all latest orders.</div>
    @endif
    <div class="overflow-x-auto bg-white border border-slate-200 rounded">
        <table class="w-full text-sm table-sticky table-hover">
            <thead class="bg-slate-50 border-b border-slate-200">
                <tr>
                    <th class="p-2 text-left">Ref</th>
                    <th class="p-2">Email</th>
                    <th class="p-2">Amount</th>
                    <th class="p-2">Status</th>
                    <th class="p-2">Placed</th>
                    <th class="p-2">Created</th>
                    <th class="p-2">Type</th>
                    <th class="p-2"></th>
                </tr>
            </thead>
            <tbody>
                @foreach($orders as $order)
                <tr class="border-b border-slate-100">
                    <td class="p-2">{{ $order->reference }}</td>
                    <td class="p-2 text-center">{{ $order->email }}</td>
                    <td class="p-2 text-center">{{ config('payment.currency_symbol', '$') }}{{ number_format($order->amount_kobo/100,2) }}</td>
                    <td class="p-2 text-center">{{ $order->status }}</td>
                    <td class="p-2 text-center">{{ optional($order->placed_at)->format('Y-m-d H:i') }}</td>
                    <td class="p-2 text-center">{{ optional($order->created_at)->format('Y-m-d H:i') }}</td>
                    <td class="p-2 text-center">@if(data_get($order->metadata,'is_test'))<span class="inline-block text-xs bg-yellow-100 text-yellow-800 px-2 py-0.5 rounded">Test</span>@else Real @endif</td>
                    <td class="p-2 text-right"><a href="{{ route('admin.orders.show', $order) }}" class="text-primary">View</a></td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <div class="mt-4">{{ $orders->links() }}</div>
</div>
@endsection
