﻿@extends('layouts.admin')

@section('content')
<div class="max-w-5xl mx-auto" data-aos="fade-up">
    <div class="bg-white border border-slate-200 rounded p-4 mb-4">
        <h1 class="heading text-2xl mb-2">Order {{ $order->reference }}</h1>
        <div class="text-sm text-slate-600">{{ $order->email }} &bull; {{ config('payment.currency_symbol', '$') }}{{ number_format($order->amount_kobo/100,2) }} &bull; Status: <span class="font-semibold">{{ $order->status }}</span></div>
    </div>

    <div class="grid md:grid-cols-2 gap-6">
        <div class="bg-white border border-slate-200 rounded p-4">
            <div class="font-semibold mb-2">Items</div>
            <ul class="text-sm space-y-2">
                @foreach($order->items as $item)
                    <li class="flex justify-between"><span>{{ $item->title }} &times; {{ $item->qty }}</span><span>{{ config('payment.currency_symbol', '$') }}{{ number_format($item->total_kobo/100,2) }}</span></li>
                @endforeach
            </ul>
        </div>
        <div class="bg-white border border-slate-200 rounded p-4">
            <div class="font-semibold mb-2">Update Status</div>
            <form action="{{ route('admin.orders.status', $order) }}" method="post" class="flex items-center gap-2">
                @csrf
                @method('PATCH')
                <select name="status" class="border border-slate-300 rounded px-3 py-2">
                    @foreach(['pending','paid','fulfilled','cancelled'] as $status)
                        <option value="{{ $status }}" @selected($order->status === $status)>{{ ucfirst($status) }}</option>
                    @endforeach
                </select>
                <button class="btn">Save</button>
            </form>
        </div>
    </div>
</div>
@endsection
