@extends('layouts.admin')

@section('content')
<div class="max-w-3xl mx-auto px-4 py-8" data-aos="fade-up">
    <h1 class="heading text-2xl mb-4">Edit Post</h1>
    <form action="{{ route('admin.posts.update', $post) }}" method="post" class="space-y-3 bg-white border border-slate-200 rounded p-4">
        @csrf @method('PUT')
        <input name="title" class="w-full border border-slate-300 rounded px-3 py-2" placeholder="Title" value="{{ $post->title }}" required>
        <input name="slug" class="w-full border border-slate-300 rounded px-3 py-2" placeholder="Slug (optional)" value="{{ $post->slug }}">
        <textarea name="excerpt" rows="3" class="w-full border border-slate-300 rounded px-3 py-2" placeholder="Excerpt">{{ $post->excerpt }}</textarea>
        <textarea name="body" rows="10" class="w-full border border-slate-300 rounded px-3 py-2" placeholder="Body" required>{{ $post->body }}</textarea>
        <div class="flex items-center gap-3">
            <label class="flex items-center gap-2"><input type="checkbox" name="is_published" value="1" @checked($post->is_published)> Published</label>
            <input type="datetime-local" name="published_at" class="border border-slate-300 rounded px-3 py-2" value="{{ optional($post->published_at)->format('Y-m-d\TH:i') }}">
        </div>
        <button class="btn">Save</button>
    </form>
</div>
@endsection

