@extends('layouts.admin')

@section('content')
<div class="max-w-7xl mx-auto px-4 py-8" data-aos="fade-up">
    <div class="flex items-center justify-between mb-4">
        <h1 class="heading text-2xl">Posts</h1>
        @can('create', App\Models\Post::class)
        <a class="btn" href="{{ route('admin.posts.create') }}">New Post</a>
        @endcan
    </div>
    <div class="overflow-x-auto bg-white border border-slate-200 rounded">
        <table class="w-full text-sm table-sticky table-hover">
            <thead class="bg-slate-50 border-b border-slate-200"><tr><th class="p-2 text-left">Title</th><th class="p-2">Published</th><th class="p-2">Status</th><th class="p-2"></th></tr></thead>
            <tbody>
                @foreach($posts as $p)
                <tr class="border-b border-slate-100">
                    <td class="p-2">{{ $p->title }}</td>
                    <td class="p-2 text-center">{{ optional($p->published_at)->format('Y-m-d') }}</td>
                    <td class="p-2 text-center">{{ $p->is_published ? 'Published' : 'Draft' }}</td>
                    <td class="p-2 text-right">
                        @can('update',$p)
                        <a href="{{ route('admin.posts.edit',$p) }}" class="text-primary">Edit</a>
                        @endcan
                        @can('delete',$p)
                        <form action="{{ route('admin.posts.destroy',$p) }}" method="post" class="inline" onsubmit="return confirm('Delete post?')">
                            @csrf @method('DELETE')
                            <button class="text-red-600 ml-2">Delete</button>
                        </form>
                        @endcan
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <div class="mt-4">{{ $posts->links() }}</div>
@endsection
