@extends('layouts.admin')

@section('content')
<div class="max-w-7xl mx-auto px-4 py-8" data-aos="fade-up">
    <div class="flex items-center justify-between mb-4">
        <h1 class="heading text-2xl">Products</h1>
        @can('create', \App\Models\Product::class)
        <a class="btn" href="{{ route('admin.products.create') }}">New Product</a>
        @endcan
    </div>
    <form method="get" class="mb-4 flex flex-wrap gap-3 items-center text-sm">
        <input name="q" value="{{ $q ?? '' }}" placeholder="Search title..." class="border border-slate-300 rounded px-3 py-1">
        <select name="category_id" class="border border-slate-300 rounded px-3 py-1">
            <option value="">All categories</option>
            @foreach(($categories ?? []) as $cat)
                <option value="{{ $cat->id }}" @selected(($categoryId ?? null)==$cat->id)>{{ $cat->name }}</option>
            @endforeach
        </select>
        <select name="filter" class="border border-slate-300 rounded px-3 py-1">
            @php($filters = ['latest' => 'Latest','discounted' => 'Discounted','featured' => 'Featured'])
            @foreach($filters as $key => $label)
                <option value="{{ $key }}" @selected(($filter ?? 'latest') === $key)>{{ $label }}</option>
            @endforeach
        </select>
        <label class="inline-flex items-center gap-1"><input type="checkbox" name="low" value="1" @checked($low ?? false)> <span>Low stock</span></label>
        <button class="btn-secondary">Apply</button>
    </form>

    <div class="overflow-x-auto bg-white border border-slate-200 rounded">
        <table class="w-full text-sm table-sticky table-hover">
            <thead class="bg-slate-50 border-b border-slate-200">
                <tr>
                    <th class="p-2 text-left">Cover</th>
                    <th class="p-2 text-left">Title</th>
                    <th class="p-2">Category</th>
                    <th class="p-2">Type</th>
                    <th class="p-2">Price</th>
                    <th class="p-2">Hardcopy Stock</th>
                    <th class="p-2">Published</th>
                    <th class="p-2"></th>
                </tr>
            </thead>
            <tbody>
                @foreach($products as $product)
                <tr class="border-b border-slate-100">
                    <td class="p-2">
                        @php($coverUrl = $product->cover_url)
                        <img
                            src="{{ $coverUrl ?? 'https://picsum.photos/seed/'.$product->id.'/80/80' }}"
                            alt="Cover"
                            width="60"
                            height="80"
                            style="width:60px;height:80px;object-fit:cover;border-radius:6px;border:1px solid #e2e8f0;"
                        >
                    </td>
                    <td class="p-2">{{ $product->title }} @if($product->sale_price_kobo && $product->sale_price_kobo < $product->price_kobo)<span class="badge badge-yellow ml-1">Sale</span>@endif @if($product->is_featured)<span class="badge badge-blue ml-1">Featured</span>@endif @if($product->has_hardcopy)<span class="badge badge-green ml-1">Hardcopy</span>@endif</td>
                    <td class="p-2 text-center">{{ optional($product->category)->name }}</td>
                    <td class="p-2 text-center">{{ $product->type }}</td>
                    <td class="p-2 text-center">
                        @if($product->sale_price_kobo && $product->sale_price_kobo < $product->price_kobo)
                            <span class="line-through text-slate-400 mr-1">{{ config('payment.currency_symbol', '$') }}{{ number_format($product->price_kobo/100, 2) }}</span>
                            <span>{{ config('payment.currency_symbol', '$') }}{{ number_format($product->sale_price_kobo/100, 2) }}</span>
                        @else
                            <span>{{ config('payment.currency_symbol', '$') }}{{ number_format(($product->price)/100, 2) }}</span>
                        @endif
                    </td>
                    <td class="p-2 text-center">{{ $product->has_hardcopy ? $product->stock : '—' }}</td>
                    <td class="p-2 text-center">{{ optional($product->published_at)->format('Y-m-d') }}</td>
                    <td class="p-2 text-right">
                        @can('update', $product)
                        <a href="{{ route('admin.products.edit', $product) }}" class="text-primary">Edit</a>
                        @endcan
                        @can('delete', $product)
                        <form action="{{ route('admin.products.destroy', $product) }}" method="post" class="inline" onsubmit="return confirm('Delete product?')">
                            @csrf
                            @method('DELETE')
                            <button class="text-red-600 ml-2">Delete</button>
                        </form>
                        @endcan
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <div class="mt-4">{{ $products->links() }}</div>
</div>
@endsection
