@php
use Illuminate\Support\Arr;
use Illuminate\Support\Str;
@endphp

@foreach ($defaults as $key => $default)
    @php
        $label = Str::headline($key);
        $inputName = $namePrefix . '[' . $key . ']';
        $dotName = $dotPrefix ? $dotPrefix . '.' . $key : $key;
        $current = Arr::get($values, $key);
    @endphp

    @if (is_array($default) && Arr::isAssoc($default))
        <div class="space-y-4 border border-slate-200 rounded p-4 mb-4">
            <h3 class="font-semibold text-base">{{ $label }}</h3>
            @include('admin.settings.partials.content-fields', [
                'defaults' => $default,
                'values' => is_array($current) ? $current : [],
                'namePrefix' => $inputName,
                'dotPrefix' => $dotName,
            ])
        </div>
    @elseif (is_array($default))
        @php
            $list = $current;
            if (is_string($list)) {
                $list = preg_split('/\r?\n/', $list);
            }
            if (!is_array($list) || empty(array_filter($list, fn ($line) => trim((string) $line) !== ''))) {
                $list = $default;
            }
            $listValue = old($dotName, implode("\n", array_map('trim', $list ?? [])));
        @endphp
        <label class="text-sm text-slate-600 flex flex-col gap-1 mb-4">
            <span>{{ $label }} (one per line)</span>
            <textarea name="{{ $inputName }}" class="border border-slate-300 rounded px-3 py-2 h-28">{{ $listValue }}</textarea>
        </label>
    @else
        @php
            $fieldValue = old($dotName, $current ?? $default ?? '');
            $isTextarea = Str::contains((string) $fieldValue, "\n") || Str::length((string) $fieldValue) > 120;
        @endphp
        <label class="text-sm text-slate-600 flex flex-col gap-1 mb-4">
            <span>{{ $label }}</span>
            @if ($isTextarea)
                <textarea name="{{ $inputName }}" class="border border-slate-300 rounded px-3 py-2 h-24">{{ $fieldValue }}</textarea>
            @else
                <input type="text" name="{{ $inputName }}" value="{{ $fieldValue }}" class="border border-slate-300 rounded px-3 py-2" />
            @endif
        </label>
    @endif
@endforeach
