@extends('layouts.auth-card')

@section('content')
    <div class="mx-auto w-full max-w-md mt-4 sm:mt-0">
        <h1 class="text-3xl font-semibold text-slate-900">Welcome Back :)</h1>
        <p class="mt-2 text-sm text-slate-600">To keep connected with us, please login with your email and password.</p>

        @if (session('status'))
            <div class="mt-4 rounded-md bg-green-50 p-3 text-sm text-green-700">{{ session('status') }}</div>
        @endif
        @if ($errors->any())
            <div class="mt-4 rounded-md bg-red-50 p-3 text-sm text-red-700">
                <ul class="list-disc pl-5">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form class="mt-5 space-y-4" method="POST" action="{{ route('login') }}">
            @csrf
            <div class="relative">
                <span class="pointer-events-none absolute inset-y-0 left-3 inline-flex items-center text-slate-400">
                    <svg  xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 7l9 6 9-6M5 6h14a2 2 0 012 2v8a2 2 0 01-2 2H5a2 2 0 01-2-2V8a2 2 0 012-2z"/></svg>
                </span>
                <input id="email" name="email" type="email" required autocomplete="email"
                       value="{{ old('email') }}"
                       class="w-full rounded-xl border-0 bg-slate-50 pl-10 pr-3 py-3 text-slate-900 shadow-inner focus:border-cyan-500 focus:bg-white focus:outline-none focus:ring-2 focus:ring-cyan-400" placeholder="Email address" />
            </div>
            <div class="relative">
                <span class="pointer-events-none absolute inset-y-0 left-3 inline-flex items-center text-slate-400">
                    <svg  xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M8 11V7a4 4 0 118 0v4m-9 0h10a2 2 0 012 2v5a2 2 0 01-2 2H7a2 2 0 01-2-2v-5a2 2 0 012-2z"/></svg>
                </span>
                <input id="password" name="password" type="password" required autocomplete="current-password"
                       class="w-full rounded-xl border-0 bg-slate-50 pl-10 pr-3 py-3 text-slate-900 shadow-inner focus:border-cyan-500 focus:bg-white focus:outline-none focus:ring-2 focus:ring-cyan-400" placeholder="Password" />
            </div>
            <div class="flex items-center justify-between text-sm">
                <label class="flex items-center gap-2 text-slate-600">
                    <input id="remember_me" name="remember" value="1" type="checkbox" class="rounded border-slate-300 text-cyan-600 focus:ring-cyan-500" {{ old('remember') ? 'checked' : '' }}>
                    Remember me
                </label>
                @if (Route::has('password.request'))
                    <a href="{{ route('password.request') }}" class="text-slate-600 hover:text-slate-800">Forgot password?</a>
                @endif
            </div>
            <div class="mt-5"><button type="submit" class="w-full rounded-full border border-black px-5 py-2.5 text-black bg-white shadow-inner hover:bg-slate-100 focus:outline-none focus:ring-2 focus:ring-slate-400">Login Now</button></div>
<div class="mt-3 text-center"> 
    <a href="{{ route('register') }}" class="inline-flex items-center justify-center rounded-full border border-black px-5 py-2 text-black hover:bg-slate-100 transition"> Create Account </a> 
</div>

        </form>

        <div class="mt-6 text-center text-xs text-slate-500">Or continue with</div>
        <div class="mt-3 flex items-center justify-center gap-3">
            <a href="{{ route('oauth.redirect', ['provider' => 'google']) }}" aria-label="Sign in with Google" class="h-10 w-10 inline-flex items-center justify-center rounded-full hover:bg-slate-50">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 533.5 544.3" class="h-5 w-5"><path fill="#4285F4" d="M533.5 278.4c0-17.4-1.6-34.1-4.6-50.3H272v95.1h147.3c-6.4 34.6-25.8 63.9-55 83.5v69h88.9c52-48 80.3-118.7 80.3-197.3z"/><path fill="#34A853" d="M272 544.3c73 0 134.3-24.1 179-65.6l-88.9-69c-24.7 16.6-56.3 26.4-90.1 26.4-69 0-127.5-46.5-148.4-109h-92.7v68.4C74.9 489.1 166.4 544.3 272 544.3z"/><path fill="#FBBC05" d="M123.6 326.1c-9.7-28.9-9.7-60.1 0-89l.1-68.4H31C-10.3 236.7-10.3 344.9 31 405.9l92.6-79.8z"/><path fill="#EA4335" d="M272 107.7c39.8-.6 77.9 14.9 106.7 43.3l79.6-79.6C408.1 24.1 347.2-.1 272 0 166.4 0 74.9 55.2 31 161.6l92.6 68.4C144.5 154.2 203 107.7 272 107.7z"/></svg>
            </a>
            <a href="{{ route('oauth.redirect', ['provider' => 'facebook']) }}" aria-label="Sign in with Facebook" class="h-10 w-10 inline-flex items-center justify-center rounded-full hover:bg-slate-50">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="h-5 w-5 fill-[#1877F2]"><path d="M22.675 0H1.325C.593 0 0 .593 0 1.325v21.35C0 23.406.593 24 1.325 24h11.49v-9.294H9.691V11.01h3.124V8.41c0-3.1 1.893-4.788 4.66-4.788 1.325 0 2.463.099 2.795.143v3.24l-1.918.001c-1.504 0-1.796.715-1.796 1.764v2.314h3.59l-.467 3.696h-3.123V24h6.125C23.406 24 24 23.406 24 22.675V1.325C24 .593 23.406 0 22.675 0z"/></svg>
            </a>
            <a href="{{ route('oauth.redirect', ['provider' => 'twitter']) }}" aria-label="Sign in with Twitter" class="h-10 w-10 inline-flex items-center justify-center rounded-full hover:bg-slate-50">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="h-5 w-5 fill-black"><path d="M18.244 2H21.5l-7.5 8.571L22 22h-6.172l-4.82-5.714L5.5 22H2.244l8.036-9.171L2 2h6.236l4.357 5.143L18.244 2zm-1.08 18h2.037L7.94 4H5.901l11.263 16z"/></svg>
            </a>
            <a href="{{ route('oauth.redirect', ['provider' => 'linkedin']) }}" aria-label="Sign in with LinkedIn" class="h-10 w-10 inline-flex items-center justify-center rounded-full hover:bg-slate-50">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="h-5 w-5 fill-[#0A66C2]"><path d="M4.98 3.5C4.98 4.88 3.86 6 2.5 6S0 4.88 0 3.5 1.12 1 2.5 1 4.98 2.12 4.98 3.5zM0 8h5v16H0zM8 8h4.8v2.2h.07c.67-1.26 2.3-2.6 4.73-2.6 5.06 0 6 3.33 6 7.66V24h-5v-7.56c0-1.8-.03-4.1-2.5-4.1-2.5 0-2.88 1.95-2.88 3.96V24H8z"/></svg>
            </a>
        </div>
    </div>
@endsection
















