@extends('layouts.auth-card')

@section('content')
<div class="mx-auto w-full max-w-md mt-4 sm:mt-0">
  <h1 class="text-2xl font-semibold text-slate-900">Verify your email</h1>
  <p class="mt-2 text-sm text-slate-600">Please verify your email address by clicking on the link we just emailed to you. If you didn't receive the email, we will gladly send you another.</p>

  @if (session('status') == 'verification-link-sent')
    <div class="mt-4 rounded-md bg-green-50 p-3 text-sm text-green-700">A new verification link has been sent to the email address you provided.</div>
  @endif

  <form method="POST" action="{{ route('verification.send') }}" class="mt-6">
    @csrf
    <button type="submit" class="w-full rounded-full bg-cyan-600 px-5 py-2.5 text-white shadow-inner hover:bg-cyan-700 focus:outline-none focus:ring-2 focus:ring-cyan-400">Resend Verification Email</button>
  </form>

  <form method="POST" action="{{ route('logout') }}" class="mt-3 text-center">
    @csrf
    <button type="submit" class="text-sm text-slate-600 hover:text-slate-800">Log Out</button>
  </form>
</div>
@endsection

