@extends('layouts.site')

@section('title', 'Blog')
@php $blogContent = $siteSettings->content('blog'); @endphp
@section('meta_description', $blogContent['index_intro'] ?? 'Latest essays, interviews, and behind-the-pages reflections from BrightQuill.')

@section('content')
<section class="section reveal">
    <div class="container">
        <h1 class="mt-0">{{ $blogContent['index_title'] ?? 'BrightQuill Journal' }}</h1>
        <p>{{ $blogContent['index_intro'] ?? 'Short essays and production notes for readers who enjoy process, margin scribbles, and joyful marketing experiments.' }}</p>
        <div class="grid grid-3 mt-2">
            @foreach($posts as $post)
                <article class="card reveal">
                    <div class="card-body">
                        <div class="badge-pill">{{ optional($post->published_at)->format('M j, Y') }}</div>
                        <h3 class="card-title">{{ $post->title }}</h3>
                        <p class="card-sub">{{ $post->excerpt }}</p>
                        <a class="btn btn-primary mt-2" href="{{ route('blog.show', $post->slug) }}">{{ $blogContent['read_story_label'] ?? 'Read story' }}</a>
                    </div>
                </article>
            @endforeach
        </div>
        <div class="mt-3">{{ $posts->links() }}</div>
    </div>
</section>
@endsection
