@extends('layouts.site')

@section('title', $post->title)
@php $blogContent = $siteSettings->content('blog'); @endphp
@section('meta_description', $post->excerpt ?? \Illuminate\Support\Str::limit($post->body, 140, '...'))

@section('content')
<section class="section reveal">
    <div class="container" style="max-width:760px;">
        <div class="badge-pill">{{ optional($post->published_at)->format('M j, Y') }}</div>
        <h1 class="mt-2">{{ $post->title }}</h1>
        <article class="mt-2" style="line-height:1.8;">
            {!! nl2br(e($post->body)) !!}
        </article>
    </div>
</section>

<section class="section stripe reveal">
    <div class="container" style="max-width:760px;">
        <h2 class="mt-0">{{ $blogContent['comments_title'] ?? 'Join the discussion' }}</h2>
        <form class="card mt-2" action="{{ route('blog.comment', $post->slug) }}" method="post">
            <div class="card-body">
                @csrf
                <label class="small" for="comment-name">{{ $blogContent['comment_name_label'] ?? 'Name' }}</label>
                <input class="input mt-1" id="comment-name" name="name" type="text" required>
                <label class="small mt-3" for="comment-body">{{ $blogContent['comment_body_label'] ?? 'Comment' }}</label>
                <textarea class="textarea mt-1" id="comment-body" name="body" rows="4" required></textarea>
                <button class="btn btn-primary mt-3" type="submit">{{ $blogContent['comments_submit_label'] ?? 'Post comment' }}</button>
            </div>
        </form>
        @if($post->comments->isNotEmpty())
            <div class="mt-3">
                <h3 class="mt-0">{{ $blogContent['recent_comments_title'] ?? 'Recent comments' }}</h3>
                <div class="grid mt-2" style="gap:1rem;">
                    @foreach($post->comments as $comment)
                        <div class="card reveal"><div class="card-body"><strong>{{ $comment->name }}</strong><p class="small" style="margin-top:.25rem;">{{ optional($comment->created_at)->diffForHumans() }}</p><p class="card-sub" style="margin-top:.5rem;">{{ $comment->body }}</p></div></div>
                    @endforeach
                </div>
            </div>
        @endif
    </div>
</section>
@endsection
