@extends('layouts.site')

@section('title', 'Books')
@php
    $booksContent = $siteSettings->content('books');
    $currency = config('payment.currency_symbol', '$');
    $introCopy = $booksContent['index_intro'] ?? 'Discover the full catalog of books and limited-edition merch available from BrightQuill.';
    $searchValue = $searchTerm ?? '';
@endphp
@section('meta_description', $introCopy)

@section('content')
<section class="section reveal">
    <div class="container">
        <h1 class="mt-0">{{ $booksContent['index_title'] ?? 'Browse the shelves' }}</h1>
        <p>{{ $introCopy }}</p>
        <form class="mt-2" method="get" style="display:flex;gap:.75rem;flex-wrap:wrap;align-items:center;">
            <input class="input" type="search" name="q" value="{{ $searchValue }}" placeholder="Search by title">
            <button class="btn btn-primary" type="submit">{{ $booksContent['search_button_label'] ?? 'Search' }}</button>
        </form>
        <div class="grid grid-3 mt-2">
            @forelse($products as $book)
                <article class="card reveal">
                    <div style="position:relative;">
                        @if($book->has_hardcopy)
                            <span class="badge" style="position:absolute;top:12px;left:12px;background:#16a34a;color:#fff;font-size:.7rem;padding:.25rem .5rem;border-radius:999px;">Hardcopy Available</span>
                        @endif
                        @php($coverUrl = $book->cover_url)
                        <img class="book-cover" src="{{ $coverUrl ?? asset('brightquill/assets/placeholder-cover.svg') }}" alt="{{ $book->title }}">
                    </div>
                    <div class="card-body">
                        <h3 class="card-title">{{ $book->title }}</h3>
                        <p class="card-sub">{{ $book->excerpt ?: \Illuminate\Support\Str::limit($book->description ?? '', 100, '...') }}</p>
                        <div class="row" style="justify-content:space-between;align-items:center;">
                            <span class="price">{{ $currency }}{{ number_format($book->price / 100, 2) }}</span>
                            @if($book->category)
                                <span class="small">{{ $book->category->name }}</span>
                            @endif
                        </div>
                        @if($book->has_hardcopy && $book->hardcopy_price)
                            <div class="row" style="justify-content:space-between;align-items:center;margin-top:.35rem;">
                                <span class="small text-slate-500">Hardcopy price</span>
                                <span class="price" style="font-size:1rem;">{{ $currency }}{{ number_format($book->hardcopy_price / 100, 2) }}</span>
                            </div>
                        @endif
                        <div class="row mt-2" style="gap:.5rem;flex-wrap:wrap;">
                            <a class="btn btn-outline" href="{{ route('books.show', $book->slug) }}">{{ $siteSettings->get('content.books.view_button_label', 'View') }}</a>
                            <form action="{{ route('cart.add', $book->slug) }}" method="post" style="margin:0;">
                                @csrf
                                <input type="hidden" name="qty" value="1">
                                <input type="hidden" name="variant" value="digital">
                                <button class="btn btn-primary" type="submit">{{ $booksContent['add_button_label'] ?? 'Add Digital' }}</button>
                            </form>
                            @if($book->has_hardcopy && $book->hardcopy_price)
                                <form action="{{ route('cart.add', $book->slug) }}" method="post" style="margin:0;">
                                    @csrf
                                    <input type="hidden" name="qty" value="1">
                                    <input type="hidden" name="variant" value="hardcopy">
                                    <button class="btn btn-outline" type="submit">Add Hardcopy</button>
                                </form>
                            @endif
                        </div>
                    </div>
                </article>
            @empty
                @if($searchValue !== '')
                    <p class="small">No books matched {{ $searchValue }}. Try a different title.</p>
                @else
                    <p class="small">No books are available yet. Please check back soon.</p>
                @endif
            @endforelse
        </div>
        <div class="mt-3">{{ $products->links() }}</div>
    </div>
</section>
@endsection
