@extends('layouts.site')

@section('title', $product->title)
@php $bookContent = $siteSettings->content('book'); @endphp
@section('meta_description', $product->excerpt ?? $bookContent['excerpt_fallback'] ?? \Illuminate\Support\Str::limit($product->description ?? '', 140, '...'))

@php
    $currency = config('payment.currency_symbol', '$');
    $coverUrl = $product->cover_url;
@endphp

@section('content')
<section class="section reveal">
    <div class="container grid grid-2">
        <div class="card reveal" style="position:relative;">
            @if($product->has_hardcopy)
                <span class="badge" style="position:absolute;top:12px;left:12px;background:#16a34a;color:#fff;font-size:.7rem;padding:.25rem .5rem;border-radius:999px;">Hardcopy Available</span>
            @endif
            <img class="book-cover" src="{{ $coverUrl ?? asset('brightquill/assets/placeholder-cover.svg') }}" alt="{{ $product->title }}">
        </div>
        <div>
            <div class="badge-pill">{{ ucfirst($bookContent['badge_label'] ?? ($product->type ?? 'book')) }}</div>
            <h1 class="mt-2">{{ $product->title }}</h1>
            <p class="lead">{{ $product->excerpt ?? $bookContent['excerpt_fallback'] ?? 'A reader-loved release from ' . config('app.name', 'BrightQuill') }}</p>
            <div class="stack" style="display:flex;flex-direction:column;gap:.35rem;margin-top:1rem;">
                <div class="row" style="justify-content:space-between;align-items:center;">
                    <span class="small text-slate-500">Digital</span>
                    <span class="price" style="font-size:1.35rem;">{{ $currency }}{{ number_format($product->price/100, 2) }}</span>
                </div>
                @if($product->has_hardcopy && $product->hardcopy_price)
                <div class="row" style="justify-content:space-between;align-items:center;">
                    <span class="small text-slate-500">Hardcopy</span>
                    <span class="price" style="font-size:1.2rem;">{{ $currency }}{{ number_format($product->hardcopy_price/100, 2) }}</span>
                </div>
                @endif
                @if($product->has_hardcopy && $product->shipping_fee_kobo)
                    <span class="small text-slate-400">Shipping: {{ $currency }}{{ number_format($product->shipping_fee_kobo/100, 2) }}</span>
                @endif
            </div>
            <div class="row" style="gap:1rem;flex-wrap:wrap;margin-top:1.5rem;">
                <form action="{{ route('cart.add', $product->slug) }}" method="post" class="card" style="padding:1rem;flex:1 1 220px;display:flex;flex-direction:column;gap:.75rem;">
                    @csrf
                    <input type="hidden" name="variant" value="digital">
                    <input type="hidden" name="qty" value="1">
                    <div class="small text-slate-500">Digital {{ strtoupper($product->type) }}</div>
                    <p class="small text-slate-500" style="margin:0;">Digital editions are delivered instantly (1 copy).</p>
                    <button class="btn btn-primary" type="submit">Add Digital to Cart</button>
                </form>
                @if($product->has_hardcopy && $product->hardcopy_price)
                <form action="{{ route('cart.add', $product->slug) }}" method="post" class="card" style="padding:1rem;flex:1 1 220px;display:flex;flex-direction:column;gap:.75rem;">
                    @csrf
                    <input type="hidden" name="variant" value="hardcopy">
                    <div class="small text-slate-500">Hardcopy Edition</div>
                    <label class="small" for="qty-hardcopy">Quantity</label>
                    <input class="input" id="qty-hardcopy" type="number" min="1" name="qty" value="1" style="max-width:120px;">
                    <button class="btn btn-outline" type="submit">Add Hardcopy to Cart</button>
                </form>
                @endif
            </div>
            <div class="mt-3" style="line-height:1.7;">{!! nl2br(e($product->description)) !!}</div>
        </div>
    </div>
</section>

@if($related->isNotEmpty())
<section class="section stripe reveal">
    <div class="container">
        <h2 class="mt-0">{{ $bookContent['related_title'] ?? 'You may also enjoy' }}</h2>
        <div class="grid grid-3 mt-2">
            @foreach($related as $book)
                <article class="card reveal">
                    <div style="position:relative;">
                        @if($book->has_hardcopy)
                            <span class="badge" style="position:absolute;top:12px;left:12px;background:#16a34a;color:#fff;font-size:.7rem;padding:.25rem .5rem;border-radius:999px;">Hardcopy</span>
                        @endif
                        @php($relatedCover = $book->cover_url)
                        <img class="book-cover" src="{{ $relatedCover ?? asset('brightquill/assets/placeholder-cover.svg') }}" alt="{{ $book->title }}">
                    </div>
                    <div class="card-body">
                        <h3 class="card-title">{{ $book->title }}</h3>
                        <p class="card-sub">{{ $book->excerpt ?: \Illuminate\Support\Str::limit($book->description ?? '', 80, '...') }}</p>
                        <div class="row" style="justify-content:space-between;align-items:center;">
                            <span class="price">{{ $currency }}{{ number_format($book->price/100, 2) }}</span>
                            <a class="btn btn-outline" href="{{ route('books.show', $book->slug) }}">{{ $siteSettings->get('content.books.view_button_label', 'View') }}</a>
                        </div>
                    </div>
                </article>
            @endforeach
        </div>
    </div>
</section>
@endif
@endsection
