@php
    use Illuminate\Support\Collection;

    $fieldId = $id ?? (is_string($name ?? null) ? trim(str_replace(['[',']'], ['_',''], $name), '_') : 'state');
    $selectedValue = is_string($value ?? null) ? strtolower(trim($value)) : null;
    $collection = $states instanceof Collection ? $states : collect($states);
    $hasOptions = $collection->isNotEmpty();
@endphp

<select
    id="{{ $fieldId }}"
    name="{{ $name }}"
    {{ $required ? 'required' : '' }}
    {{ $hasOptions ? '' : 'disabled' }}
    data-placeholder="{{ $placeholder }}"
    data-fallback="{{ $fallback }}"
    {{ $attributes->class(['input']) }}
>
    <option value="">{{ $hasOptions ? $placeholder : $fallback }}</option>
    @foreach($collection as $state)
        @php
            $code = strtolower((string) ($state['code'] ?? $state));
            $label = (string) ($state['name'] ?? $state);
        @endphp
        <option value="{{ strtoupper($state['code'] ?? $label) }}" @selected($selectedValue === $code)>
            {{ $label }}
        </option>
    @endforeach
</select>
