@extends('layouts.site')

@section('title', 'Contact')
@php $contactContent = $siteSettings->content('contact'); @endphp
@section('meta_description', $contactContent['intro_body'] ?? 'Get in touch with the team behind BrightQuill for events, collaborations, or reader support.')

@section('content')
<section class="section reveal">
    <div class="container grid grid-2">
        <div>
            <h1 class="mt-0">{{ $contactContent['page_title'] ?? 'Say hello' }}</h1>
            <p>{{ $contactContent['intro_body'] ?? 'Have a question about an order, want to collaborate on an event, or need a custom reading guide? Drop a note and we will reply within two business days.' }}</p>
            <div class="card mt-2 reveal">
                <div class="card-body">
                    <h3 class="card-title">{{ $contactContent['details_title'] ?? 'Quick details' }}</h3>
                    <p class="card-sub">{{ $contactContent['details_email_label'] ?? 'Email' }}: <a href="mailto:hello@example.com">hello@example.com</a></p>
                    <p class="card-sub">{{ $contactContent['details_hours'] ?? 'Office hours: Mon - Fri, 9am to 4pm WAT' }}</p>
                    <p class="card-sub">{{ $contactContent['details_press'] ?? 'Press kit available upon request.' }}</p>
                </div>
            </div>
        </div>
        <div>
            <form class="card reveal" action="{{ route('contact.send') }}" method="post">
                <div class="card-body">
                    <h2 class="card-title">{{ $contactContent['form_title'] ?? 'Send a message' }}</h2>
                    @csrf
                    <label class="small" for="contact-name">{{ $contactContent['form_name_label'] ?? 'Name' }}</label>
                    <input class="input mt-1" id="contact-name" name="name" type="text" required placeholder="Your name">
                    <label class="small mt-3" for="contact-email">{{ $contactContent['form_email_label'] ?? 'Email' }}</label>
                    <input class="input mt-1" id="contact-email" name="email" type="email" required placeholder="you@example.com">
                    <label class="small mt-3" for="contact-message">{{ $contactContent['form_message_label'] ?? 'Message' }}</label>
                    <textarea class="textarea mt-1" id="contact-message" name="message" rows="5" required placeholder="How can we help?"></textarea>
                    <button class="btn btn-primary mt-3" type="submit">{{ $contactContent['form_submit_label'] ?? 'Send message' }}</button>
                </div>
            </form>
        </div>
    </div>
</section>
@endsection
