@php
    $appName = config('app.name', 'BrightQuill');
@endphp

<x-mail::message>
# Your downloads are ready

Thanks for your purchase, {{ $order->name ?? 'reader' }}! Your order **{{ $order->reference }}** is confirmed and the digital files are ready whenever you are.

@foreach($downloads as $download)
<x-mail::panel>
**{{ $download['title'] }}**

<x-mail::button :url="$download['url']">
Download file
</x-mail::button>

@if(!empty($download['expires_at']))
> Available until {{ $download['expires_at']->timezone(config('app.timezone'))->toFormattedDateString() }}
@endif
</x-mail::panel>
@endforeach

Need help accessing your files? Just reply to this message and we’ll be glad to assist.

Happy reading!  
{{ $appName }} Support
</x-mail::message>
