@php
    $appName = config('app.name', 'BrightQuill');
    $address = collect($order->address_json ?? [])->filter()->all();
@endphp

<x-mail::message>
# Your order is on the way

Great news, {{ $order->name ?? 'reader' }}! We've packed up order **{{ $order->reference }}** and it's headed your way.

**Shipping to:**  
@foreach($address as $line)
{{ $line }}  
@endforeach

**Items in this shipment:**
@component('mail::panel')
@foreach($items as $item)
- {{ $item->title }} &times; {{ $item->qty }}
@endforeach
@endcomponent

We'll let you know as soon as it's scanned in by the carrier. If anything looks off, just reply to this email and we'll take care of it.

Thanks again for shopping with {{ $appName }}!  
{{ $appName }} Support
</x-mail::message>
