@php($isAdminArea = str_starts_with(request()->path(), 'admin'))
@extends($isAdminArea ? 'layouts.admin' : 'layouts.app')

@section('content')
<div class="max-w-3xl mx-auto px-4 py-16" data-aos="fade-up">
    <h1 class="heading text-3xl mb-3 text-ink">Access denied</h1>
    <p class="text-slate-600 mb-6">You don’t have permission to view this page.</p>
    @auth
        @if($isAdminArea)
            <a href="{{ route('admin.dashboard') }}" class="btn">Go to Dashboard</a>
        @else
            <a href="{{ route('home') }}" class="btn-primary px-4 py-2 rounded">Back to Home</a>
        @endif
    @else
        <a href="{{ route('login') }}" class="btn-primary px-4 py-2 rounded">Login</a>
    @endauth
</div>
@endsection

