<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-sans antialiased bg-gradient-to-br from-indigo-900 via-fuchsia-800 to-amber-700 text-slate-100">
        <div class="relative flex min-h-screen flex-col overflow-hidden">
            <div aria-hidden="true" class="pointer-events-none absolute inset-0 -z-10">
                <div class="h-full w-full bg-gradient-to-br from-indigo-950 via-fuchsia-950 to-amber-900"></div>
                <div class="absolute top-24 left-1/2 h-[28rem] w-[28rem] -translate-x-1/2 rounded-full bg-fuchsia-500/40 blur-3xl"></div>
                <div class="absolute bottom-0 right-12 h-72 w-72 rounded-full bg-amber-400/40 blur-3xl"></div>
            </div>

            <header class="mx-auto flex w-full max-w-6xl items-center justify-between px-6 pt-10 sm:px-12">
                <a href="/" class="inline-flex items-center space-x-3 text-slate-100 hover:text-white">
                    <x-application-logo class="h-12 w-12 text-indigo-300" />
                    <span class="text-lg font-semibold tracking-wide">{{ config('app.name', 'Book Store') }}</span>
                </a>
                <p class="hidden text-sm text-slate-300 md:block">Curated titles & tailored recommendations.</p>
            </header>

            <main class="mx-auto flex w-full max-w-3xl flex-1 flex-col justify-center px-6 pb-16 pt-10 sm:px-12">
                <section class="w-full flex-1 rounded-3xl border border-white/10 bg-white/5 p-10 shadow-2xl backdrop-blur-xl">
                </section
>

                <aside class="relative w-full max-w-xl rounded-3xl border border-white/20 bg-white/90 p-8 shadow-2xl backdrop-blur-sm ring-1 ring-white/30">
                    <h2 class="text-2xl font-semibold text-slate-900">Welcome back</h2>
                    <p class="mt-2 text-sm text-slate-700">Sign in or create an account to continue.</p>
                    <div class="mt-6">
                        @yield('content')
                    </div>
                </aside>
            </main>

            <footer class="mx-auto w-full max-w-6xl px-6 pb-8 text-xs text-slate-400 sm:px-12">
                <p>&copy; {{ now()->year }} {{ config('app.name', 'Book Store') }}. Crafted with care for curious minds.</p>
            </footer>
        </div>
    </body>
</html>




