<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <script>document.documentElement.classList.add('js');</script>
    @php
        $appearance = $siteSettings->appearance();
        $typography = $siteSettings->typography();
        $metaDescription = trim($__env->yieldContent('meta_description'));
        if ($metaDescription === '') {
            $metaDescription = $siteSettings->get('content.footer_tagline', 'BrightQuill offers curated stories, promotions, and creative tools for curious readers and indie authors.');
        }
        $logoPath = $siteSettings->get('brand.logo_path');
        $faviconPath = $siteSettings->get('brand.favicon_path');
        $logoUrl = $logoPath ? \Illuminate\Support\Facades\Storage::disk('public')->url($logoPath) : null;
        $faviconUrl = $faviconPath ? \Illuminate\Support\Facades\Storage::disk('public')->url($faviconPath) : asset('favicon.ico');
        $faviconType = $faviconPath && str_ends_with(strtolower($faviconPath), '.ico') ? 'image/x-icon' : 'image/png';

        $brightQuillStyles = asset('brightquill/assets/styles.css');
        $brightQuillScripts = asset('brightquill/assets/scripts.js');

        if (file_exists(public_path('brightquill/assets/styles.css'))) {
            $brightQuillStyles .= '?v=' . filemtime(public_path('brightquill/assets/styles.css'));
        }

        if (file_exists(public_path('brightquill/assets/scripts.js'))) {
            $brightQuillScripts .= '?v=' . filemtime(public_path('brightquill/assets/scripts.js'));
        }
    @endphp
    <title>
        @hasSection('title')
            @yield('title') | {{ config('app.name', 'BrightQuill') }}
        @else
            {{ config('app.name', 'BrightQuill') }}
        @endif
    </title>
    <meta name="description" content="{{ $metaDescription }}">
    <link rel="icon" type="{{ $faviconType }}" href="{{ $faviconUrl }}">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    @if (!empty($typography['font_embed_url']))
        <link rel="stylesheet" href="{{ $typography['font_embed_url'] }}">
    @endif
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link rel="stylesheet" href="{{ $brightQuillStyles }}">
    <style>
        :root{
            --primary: {{ $appearance['primary_color'] ?? '#1A4D8F' }};
            --primary-600: {{ $appearance['primary_alt_color'] ?? '#153F74' }};
            --accent: {{ $appearance['accent_color'] ?? '#F5B82E' }};
            --bg: {{ $appearance['background_color'] ?? '#FFFFFF' }};
            --surface: {{ $appearance['surface_color'] ?? '#F4F4F4' }};
            --ink: {{ $appearance['text_color'] ?? '#222222' }};
            --muted: {{ $appearance['muted_text_color'] ?? '#64748B' }};
            --line: {{ $appearance['line_color'] ?? '#E2E8F0' }};
        }
        body{background:var(--bg); color:var(--ink); font-family:"{{ $typography['body_font'] ?? 'Poppins' }}", Inter, ui-sans-serif, system-ui, -apple-system, "Segoe UI", Roboto, Arial, sans-serif}
        .heading{font-family:"{{ $typography['heading_font'] ?? 'Merriweather' }}", Georgia, serif}
        .brand-logo-img{height:44px;width:auto;border-radius:12px;object-fit:contain;background:#fff;padding:4px;box-shadow:0 4px 12px rgba(0,0,0,0.08)}
        #splash{position:fixed;inset:0;background:{{ $appearance['primary_color'] ?? '#1A4D8F' }};display:grid;place-items:center;z-index:80}
        #splash .logo{color:{{ $appearance['accent_color'] ?? '#F5B82E' }};font-family:"{{ $typography['heading_font'] ?? 'Merriweather' }}", Georgia, serif;font-weight:900;font-size:clamp(1.8rem,4vw,3rem);letter-spacing:.5px;animation:splashZoomBounce .9s ease both}
        #splash.hide{animation: fadeOut .45s ease forwards}
        @keyframes fadeOut{to{opacity:0;visibility:hidden}}
        .navlinks form{display:inline}
        .navlinks form button{border:none;background:none;padding:.55rem .8rem;border-radius:12px;font:inherit;color:inherit;cursor:pointer}
        .navlinks form button:hover{background:var(--surface);color:var(--primary)}
        .drawer form{margin-top:1rem}
        .drawer form button{width:100%;border:none;background:{{ $appearance['primary_color'] ?? '#1A4D8F' }};color:#fff;padding:.75rem;border-radius:12px;font-weight:700;cursor:pointer}
        .drawer a.badge{display:flex;align-items:center;justify-content:space-between;gap:.5rem}
        .grid.grid-2{display:grid;grid-template-columns:repeat(2,minmax(0,1fr));gap:1.5rem}
        .grid.grid-3{display:grid;grid-template-columns:repeat(3,minmax(0,1fr));gap:1.5rem}
        .grid.grid-4{display:grid;grid-template-columns:repeat(4,minmax(0,1fr));gap:1.5rem}
        .footer-grid{display:grid;grid-template-columns:repeat(3,minmax(0,1fr));gap:1.5rem;align-items:start}
        .card{border-radius:18px;background:#fff;box-shadow:0 20px 35px rgba(15,23,42,0.08);padding:1.5rem}
        @media (max-width: 1024px){
            .nav{flex-wrap:wrap;gap:1rem}
            .navlinks{flex-wrap:wrap;gap:.65rem}
            .grid.grid-3{grid-template-columns:repeat(2,minmax(0,1fr))}
            .grid.grid-4{grid-template-columns:repeat(2,minmax(0,1fr))}
            .grid.grid-2{grid-template-columns:repeat(2,minmax(0,1fr))}
            .container{padding-left:1.25rem;padding-right:1.25rem}
            .footer-grid{grid-template-columns:repeat(2,minmax(0,1fr))}
        }
        @media (max-width: 768px){
            body{font-size:15px}
            h1,.heading{font-size:clamp(1.65rem,5vw,2rem)}
            .grid.grid-3,
            .grid.grid-4{grid-template-columns:repeat(1,minmax(0,1fr))}
            .grid.grid-2{grid-template-columns:repeat(1,minmax(0,1fr))}
            .row,
            .stack{flex-direction:column}
            .card{padding:1.25rem}
            .cart article.card{flex-direction:column}
            .footer-grid{grid-template-columns:1fr}
            .brand{flex-direction:column;align-items:flex-start;gap:.4rem}
        }
        @media (max-width: 540px){
            .navlinks{display:none}
            .menu-btn{display:inline-flex}
            .card{padding:1rem}
            .container{padding-left:1rem;padding-right:1rem}
            .badge{font-size:.65rem}
            .section{padding:2.5rem 0}
            article.card img.book-cover{width:100%;height:auto}
            .footer-grid strong{font-size:1rem}
        }
    </style>
    @stack('styles')
</head>
<body>
    <div id="splash" aria-hidden="true">
        <div class="logo">{{ config('app.name', 'BrightQuill') }}</div>
    </div>

    @php
        $headerTagline = $siteSettings->get('content.header_tagline');
    @endphp
    <header class="header" role="banner">
        <div class="container nav" role="navigation" aria-label="Main">
            <a class="brand" href="{{ route('home') }}">
                @if ($logoUrl)
                    <img src="{{ $logoUrl }}" alt="{{ config('app.name', 'BrightQuill') }} logo" class="brand-logo-img">
                @else
                    <span class="brand-logo" aria-hidden="true"></span>
                @endif
                <span class="brand-name">{{ config('app.name', 'BrightQuill') }}</span>
            </a>
            <nav class="navlinks" aria-label="Primary">
                <a href="{{ route('home') }}" aria-current="{{ request()->routeIs('home') ? 'page' : 'false' }}">Home</a>
                <a href="{{ route('about') }}" aria-current="{{ request()->routeIs('about') ? 'page' : 'false' }}">About</a>
                <a href="{{ route('books.index') }}" aria-current="{{ request()->routeIs('books.*') ? 'page' : 'false' }}">Books</a>
                <a href="{{ route('promotions.index') }}" aria-current="{{ request()->routeIs('promotions.*') ? 'page' : 'false' }}">Promotions</a>
                <a href="{{ route('services') }}" aria-current="{{ request()->routeIs('services') ? 'page' : 'false' }}">Services &amp; Tools</a>
                <a href="{{ route('blog.index') }}" aria-current="{{ request()->routeIs('blog.*') ? 'page' : 'false' }}">Blog</a>
                <a href="{{ route('merch') }}" aria-current="{{ request()->routeIs('merch') ? 'page' : 'false' }}">Merch</a>
                <a href="{{ route('contact.show') }}" aria-current="{{ request()->routeIs('contact.*') ? 'page' : 'false' }}">Contact</a>
                <a class="badge" href="{{ route('cart.index') }}" aria-current="{{ request()->routeIs('cart.index') ? 'page' : 'false' }}" aria-label="Cart with {{ $cartSummary['qty'] ?? 0 }} items worth {{ config('payment.currency_symbol', '$') }}{{ number_format(($cartSummary['totalKobo'] ?? 0)/100, 2) }}">
                    Cart
                    <span class="count">{{ $cartSummary['qty'] ?? 0 }}</span>
                </a>
            </nav>
            <button class="menu-btn" aria-haspopup="dialog" aria-expanded="false" type="button">Menu</button>
        </div>
        @if (!empty($headerTagline))
            <div class="container" style="padding:0 1rem 0.8rem 1rem; font-size:0.85rem; color:var(--muted);">
                <p class="hidden md:block">{{ $headerTagline }}</p>
            </div>
        @endif
        <div class="drawer" role="dialog" aria-modal="true">
            <div class="drawer-panel">
                <nav class="drawer-links" aria-label="Mobile">
                    <a href="{{ route('home') }}" aria-current="{{ request()->routeIs('home') ? 'page' : 'false' }}">Home</a>
                    <a href="{{ route('about') }}" aria-current="{{ request()->routeIs('about') ? 'page' : 'false' }}">About</a>
                    <a href="{{ route('books.index') }}" aria-current="{{ request()->routeIs('books.*') ? 'page' : 'false' }}">Books</a>
                    <a href="{{ route('promotions.index') }}" aria-current="{{ request()->routeIs('promotions.*') ? 'page' : 'false' }}">Promotions</a>
                    <a href="{{ route('services') }}" aria-current="{{ request()->routeIs('services') ? 'page' : 'false' }}">Services &amp; Tools</a>
                    <a href="{{ route('blog.index') }}" aria-current="{{ request()->routeIs('blog.*') ? 'page' : 'false' }}">Blog</a>
                    <a href="{{ route('merch') }}" aria-current="{{ request()->routeIs('merch') ? 'page' : 'false' }}">Merch</a>
                    <a class="badge" href="{{ route('cart.index') }}" aria-current="{{ request()->routeIs('cart.index') ? 'page' : 'false' }}">
                        Cart
                        <span class="count">{{ $cartSummary['qty'] ?? 0 }}</span>
                    </a>
                    <a href="{{ route('contact.show') }}" aria-current="{{ request()->routeIs('contact.*') ? 'page' : 'false' }}">Contact</a>
                </nav>
            </div>
        </div>
    </header>

    @php
        $flashMessage = session('toast') ?? session('status') ?? session('success') ?? session('message');
    @endphp

    <main>
        {{ $slot ?? '' }}
        @yield('content')
    </main>

    @php
        $footerQuickLinks = $siteSettings->get('content.footer_quick_links_title', 'Quick Links');
        $footerNewsletter = $siteSettings->get('content.footer_newsletter_title', 'Newsletter');
        $footerHint = $siteSettings->get('content.footer_newsletter_hint', 'No spam. Unsubscribe anytime.');
        $footerTagline = $siteSettings->get('content.footer_tagline');
    @endphp
    <footer class="footer">
        <div class="container footer-grid">
            <div>
                <div class="brand" style="margin-bottom:.75rem">
                    @if ($logoUrl)
                        <img src="{{ $logoUrl }}" alt="{{ config('app.name', 'BrightQuill') }} logo" class="brand-logo-img">
                    @else
                        <span class="brand-logo" aria-hidden="true"></span>
                    @endif
                    <span class="brand-name">{{ config('app.name', 'BrightQuill') }}</span>
                </div>
                <p class="small">{{ $footerTagline }}</p>
            </div>
            <div>
                <strong>{{ $footerQuickLinks }}</strong>
                <div class="mt-2">
                    <div><a href="{{ route('books.index') }}">Browse Books</a></div>
                    <div><a href="{{ route('blog.index') }}">Read the Blog</a></div>
                    <div><a href="{{ route('promotions.index') }}">Promotions</a></div>
                    <div><a href="{{ route('contact.show') }}">Contact</a></div>
                    @if (Route::has('login'))
                        <div>
                            @auth
                                <a href="{{ route('admin.dashboard') }}">Admin</a>
                            @else
                                <a href="{{ route('login') }}">Login</a>
                            @endauth
                        </div>
                    @endif
                </div>
            </div>
            <div>
                <strong>{{ $footerNewsletter }}</strong>
                <form class="mt-2" action="{{ route('newsletter.subscribe') }}" method="post">
                    @csrf
                    <input required class="input" type="email" name="email" placeholder="you@example.com" aria-label="Email">
                    <button class="btn btn-primary mt-2" type="submit">Subscribe</button>
                    <p class="small mt-1">{{ $footerHint }}</p>
                </form>
            </div>
        </div>
        <div class="container small" style="padding:.75rem 0;border-top:1px solid var(--line)">
            &copy; {{ now()->year }} {{ config('app.name', 'BrightQuill') }}. All rights reserved.
        </div>
    </footer>

    <div class="toast" role="status" aria-live="polite"></div>

    <script>
        window.brightQuill = {
            cartCount: {{ $cartSummary['qty'] ?? 0 }},
            cartTotal: "{{ config('payment.currency_symbol', '$') }}{{ number_format(($cartSummary['totalKobo'] ?? 0)/100, 2) }}"
        };
    </script>
    <script src="{{ $brightQuillScripts }}"></script>
    @if ($flashMessage)
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                if (typeof toast === 'function') {
                    toast(@json($flashMessage));
                }
            });
        </script>
    @endif
    @if ($errors->any())
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                if (typeof toast === 'function') {
                    toast(@json($errors->first()));
                }
            });
        </script>
    @endif
    @stack('scripts')
</body>
</html>




