@extends('layouts.site')

@section('title', 'Merch')
@php $merchContent = $siteSettings->content('merch'); @endphp
@section('meta_description', $merchContent['intro_body'] ?? 'Limited merch drops inspired by BrightQuill stories.')

@section('content')
<section class="section reveal">
    <div class="container">
        <h1 class="mt-0">{{ $merchContent['page_title'] ?? 'BrightQuill merch' }}</h1>
        <p>{{ $merchContent['intro_body'] ?? 'Wearable reminders and desk-friendly tools for the readers who never stop recommending books.' }}</p>
        <div class="grid grid-3 mt-2">
            @foreach(range(1,6) as $i)
                <article class="card reveal">
                    <img src="https://picsum.photos/seed/merch{{ $i }}/500/500" alt="Merch item {{ $i }}">
                    <div class="card-body">
                        <h3 class="card-title">{{ ($merchContent['item_title_prefix'] ?? 'Item #') . $i }}</h3>
                        <p class="card-sub">{{ $merchContent['item_description'] ?? 'Soft cotton, hand-drawn illustration, limited run.' }}</p>
                        <div class="row" style="justify-content:space-between;align-items:center;">
                            <span class="price">{{ config('payment.currency_symbol', '$') }}{{ number_format(7500/100, 2) }}</span>
                            <a class="btn btn-outline" href="{{ route('contact.show') }}">{{ $merchContent['enquire_label'] ?? 'Enquire' }}</a>
                        </div>
                    </div>
                </article>
            @endforeach
        </div>
    </div>
</section>
@endsection
