﻿@extends('layouts.site')


@php $servicesContent = $siteSettings->content('services'); @endphp
@section('meta_description', $servicesContent['intro_body'] ?? 'Explore the workshops, templates, and reader-first resources available through BrightQuill.')

@php
    $expectPoints = $siteSettings->get('content.services.expect_points', []);
    $toolsPoints = $siteSettings->get('content.services.tools_points', []);
@endphp

@section('content')
<section class="section reveal">
    <div class="container">
        <h1 class="mt-0">{{ $servicesContent['page_title'] ?? 'Services & tools' }}</h1>
        <p>{{ $servicesContent['intro_body'] ?? 'Build a reader-loved brand with offerings crafted for indie authors, bookshops, and creative teams.' }}</p>
        <div class="grid grid-3 mt-2">
            @foreach ([
                ['key' => 'strategy', 'route' => route('contact.show')],
                ['key' => 'design', 'route' => route('contact.show')],
                ['key' => 'launch', 'route' => route('promotions.index')],
            ] as $item)
                @php
                    $prefix = $item['key'];
                @endphp
                <article class="card reveal">
                    <div class="card-body">
                        <div class="badge-pill">{{ $servicesContent[$prefix . '_badge'] ?? \Illuminate\Support\Str::title($prefix) }}</div>
                        <h3 class="card-title">{{ $servicesContent[$prefix . '_title'] ?? \Illuminate\Support\Str::title($prefix) }}</h3>
                        <p class="card-sub">{{ $servicesContent[$prefix . '_body'] ?? '' }}</p>
                        <a class="btn btn-primary" href="{{ $item['route'] }}">{{ $servicesContent[$prefix . '_cta_label'] ?? 'Learn more' }}</a>
                    </div>
                </article>
            @endforeach
        </div>
    </div>
</section>

<section class="section stripe reveal">
    <div class="container grid grid-2">
        <div>
            <h2 class="mt-0">{{ $servicesContent['expect_title'] ?? 'What to expect' }}</h2>
            @if(is_array($expectPoints) && count($expectPoints))
                <ul style="list-style:disc;padding-left:1.25rem;line-height:1.7;">
                    @foreach($expectPoints as $line)
                        <li>{{ $line }}</li>
                    @endforeach
                </ul>
            @endif
        </div>
        <div class="card reveal">
            <div class="card-body">
                <h3 class="card-title">{{ $servicesContent['tools_title'] ?? 'Tool stack we love' }}</h3>
                @if(is_array($toolsPoints) && count($toolsPoints))
                    <ul class="mt-2" style="list-style:disc;padding-left:1.25rem;line-height:1.6;">
                        @foreach($toolsPoints as $tool)
                            <li>{{ $tool }}</li>
                        @endforeach
                    </ul>
                @endif
            </div>
        </div>
    </div>
</section>

<section class="section reveal">
    <div class="container grid grid-2">
        <div>
            <h2 class="mt-0">{{ $servicesContent['partner_title'] ?? 'Partner with us' }}</h2>
            <p>{{ $servicesContent['partner_body'] ?? 'From library residencies to co-branded workshops, we design experiences that feel personal and doable.' }}</p>
            <a class="btn btn-primary mt-2" href="{{ route('contact.show') }}">{{ $servicesContent['partner_cta_label'] ?? 'Start the conversation' }}</a>
        </div>
        <div>
            <h2 class="mt-0">{{ $servicesContent['downloads_title'] ?? 'Downloadable resources' }}</h2>
            <div class="grid grid-2" style="gap:1rem;">
                <div class="card reveal"><div class="card-body"><h3 class="card-title">{{ $servicesContent['download_1_title'] ?? 'Launch checklist' }}</h3><p class="card-sub">{{ $servicesContent['download_1_body'] ?? 'A four-week countdown for stress-free release days.' }}</p></div></div>
                <div class="card reveal"><div class="card-body"><h3 class="card-title">{{ $servicesContent['download_2_title'] ?? 'Newsletter prompts' }}</h3><p class="card-sub">{{ $servicesContent['download_2_body'] ?? '12 thoughtful email ideas to keep readers engaged.' }}</p></div></div>
            </div>
        </div>
    </div>
</section>
@endsection





