﻿document.addEventListener('DOMContentLoaded', () => {
    if (window.AOS) {
        AOS.init({ once: true, offset: 80, duration: 700, easing: 'ease-out-quart' });
    }

    try {
        const observer = new IntersectionObserver((entries) => {
            entries.forEach((entry) => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('is-visible');
                    observer.unobserve(entry.target);
                }
            });
        }, { threshold: 0.15 });

        document.querySelectorAll('[data-stagger] .reveal').forEach((el, index) => {
            el.style.setProperty('--delay', `${index * 0.08}s`);
        });

        document.querySelectorAll('.reveal:not([data-aos])').forEach((el) => {
            observer.observe(el);
        });
    } catch (error) {
        console.warn('Animations disabled', error);
    }
});
