<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Comment;
use Illuminate\Http\Request;

class CommentController extends Controller
{
    public function index()
    {
        $this->authorize('viewAny', Comment::class);
        $comments = Comment::latest()->paginate(30);
        return view('admin.comments.index', compact('comments'));
    }

    public function updateStatus(Request $request, Comment $comment)
    {
        $this->authorize('update', $comment);
        $data = $request->validate(['status' => 'required|string|in:pending,approved,rejected']);
        $comment->update(['status' => $data['status'], 'approved_at' => $data['status']==='approved' ? now() : null]);
        \App\Services\AuditService::log('comment.status', $comment, $request->user(), ['status' => $data['status']]);
        return back()->with('status','Comment updated');
    }

    public function destroy(Comment $comment, Request $request)
    {
        $this->authorize('delete', $comment);
        $comment->delete();
        \App\Services\AuditService::log('comment.deleted', $comment, $request->user());
        return back()->with('status','Comment deleted');
    }
}

