<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\Post;
use App\Models\Product;
use App\Models\Subscriber;

class DashboardController extends Controller
{
    public function __invoke()
    {
        $stats = [
            'products' => Product::count(),
            'orders' => Order::count(),
            'posts' => Post::count(),
            'subscribers' => class_exists(Subscriber::class) ? Subscriber::count() : 0,
            'pending_orders' => Order::where('status','pending')->count(),
            'pending_comments' => \App\Models\Comment::where('status','pending')->count(),
            'low_stock' => Product::where('stock','<=',5)->count(),
        ];

        $latestOrders = Order::latest('created_at')->take(5)->get();
        $recentPosts = Post::latest('published_at')->take(5)->get();

        return view('admin.dashboard', compact('stats','latestOrders','recentPosts'));
    }
}
