<?php

namespace App\Http\Controllers;

use App\Models\Comment;
use App\Models\Post;
use Illuminate\Http\Request;

class BlogController extends Controller
{
    public function index()
    {
        $posts = Post::query()->where('is_published', true)->latest('published_at')->paginate(9);
        return view('blog.index', compact('posts'));
    }

    public function show(string $slug)
    {
        $post = Post::where('slug', $slug)->firstOrFail();
        $comments = $post->comments()->where('status','approved')->latest()->get();
        return view('blog.show', compact('post','comments'));
    }

    public function comment(Request $request, string $slug)
    {
        $post = Post::where('slug', $slug)->firstOrFail();
        $data = $request->validate([
            'name' => ['required','string','max:100'],
            'email' => ['required','email'],
            'comment' => ['required','string','max:5000'],
        ]);
        $post->comments()->create([
            'name' => $data['name'],
            'email' => $data['email'],
            'body' => $data['comment'],
            'status' => 'pending',
        ]);
        return back()->with('status','Comment submitted and awaiting approval.');
    }
}

