<?php

namespace App\Http\Controllers;

use App\Models\Download;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Storage;

class DownloadController extends Controller
{
    public function show(string $token)
    {
        $download = Download::with('order')
            ->where('token', $token)
            ->firstOrFail();

        if ($download->order && $download->order->status !== 'paid') {
            abort(Response::HTTP_FORBIDDEN, 'Order not paid yet.');
        }

        if ($download->expires_at && now()->greaterThan($download->expires_at)) {
            abort(Response::HTTP_GONE, 'Download link has expired.');
        }

        $disk = $download->disk ?: 'local';
        if (!Storage::disk($disk)->exists($download->path)) {
            abort(Response::HTTP_NOT_FOUND, 'File no longer available.');
        }

        if (!$download->downloaded_at) {
            $download->forceFill(['downloaded_at' => now()])->save();
        }

        $filename = basename($download->path);

        return Storage::disk($disk)->download($download->path, $filename);
    }
}
