<?php

namespace App\Http\Controllers;

use App\Models\Post;
use App\Models\Product;

class HomeController extends Controller
{
    public function __invoke()
    {
        $featured = Product::query()->where('is_featured', true)->latest('published_at')->take(6)->get();
        $posts = Post::query()->where('is_published', true)->latest('published_at')->take(3)->get();
        return view('home', compact('featured', 'posts'));
    }
}

