<?php

namespace App\Http\Controllers;

use App\Models\Promotion;
use Illuminate\Http\Request;

class PromotionController extends Controller
{
    public function index()
    {
        $promotions = Promotion::query()->where('is_active', true)->latest()->paginate(12);
        return view('promotions.index', compact('promotions'));
    }

    public function show(string $code)
    {
        $promotion = Promotion::where('code', $code)->firstOrFail();
        return view('promotions.show', compact('promotion'));
    }

    public function enter(Request $request, string $code)
    {
        $promotion = Promotion::where('code', $code)->firstOrFail();
        $data = $request->validate([
            'name' => ['required','string','max:100'],
            'email' => ['required','email'],
            'order_number' => ['nullable','string','max:50'],
            'consent' => ['accepted'],
        ]);
        $promotion->entries()->create([
            'name' => $data['name'],
            'email' => $data['email'],
            'order_number' => $data['order_number'] ?? null,
            'consent' => true,
            'ip_address' => $request->ip(),
            'user_agent' => (string) $request->userAgent(),
        ]);
        return back()->with('status','Entry received!');
    }
}

