<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class RoleMiddleware
{
    /**
     * Handle an incoming request.
     * Usage: role:admin or role:admin,cashier
     */
    public function handle(Request $request, Closure $next, string $roles): Response
    {
        $user = $request->user();
        if (!$user) {
            abort(403);
        }

        $allowed = collect(explode(',', $roles))->map(fn($r) => trim($r))->filter()->values();
        if ($allowed->isEmpty()) {
            abort(403);
        }

        if (!$allowed->contains($user->role)) {
            abort(403);
        }

        return $next($request);
    }
}

